package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.rafalzajfert.androidlogger.Logger;

import java.io.IOException;
import java.util.Map;

import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Klasa obsługująca połączenie z api metodą DELETE
 *
 * @author Rafal Zajfert
 * @date 07.01.2016
 * @see Request
 */
public abstract class DeleteRequest<T> extends Request<T> {

    protected DeleteRequest() {
    }

    @Override
    protected Response request() throws IOException {
        Logger.info("= DELETE ==========================");
        HttpUrl url = getUrl();
        Logger.info(url);
        RequestBody body = getRequestBody();
        Logger.info("===================================");

        okhttp3.Request request = createRequest(url, body);
        return mHttpClient.newCall(request).execute();
    }



    /**
     * Metoda tworząca request na podstawie {@code url} oraz {@code body}
     * @param url adres url, do którego ma zostać wysłane zapytanie
     * @param body ciało zapytania, które ma zostać wysłane
     * @return gotowy request do wysłania
     */
    @NonNull
    private okhttp3.Request createRequest(@NonNull HttpUrl url, @Nullable RequestBody body) {
        okhttp3.Request.Builder requestBuilder = new okhttp3.Request.Builder()
                .url(url)
                .addHeader(CONTENT_TYPE, MEDIA_TYPE.toString());
        for (Map.Entry<String, String> entry : mHeaders.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        if (body != null) {
            requestBuilder.delete(body);
        } else {
            requestBuilder.delete();
        }
        return requestBuilder.build();
    }
}
