package com.humandevice.android.resttools.rest.exceptions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.rafalzajfert.androidlogger.Logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-08-11
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaseErrorResponse implements ErrorResponse {

	/**
	 * Nazwa błędu
	 */
	@JsonProperty("name")
	private String mName;

	/**
	 * Wiadomość dla użytkownika
	 */
	@JsonProperty("message")
	private String mMessage;

	/**
	 * Kod błędu
	 */
	@JsonProperty("code")
	private int mCode;

	/**
	 * Kod odpowiedzi
	 */
	@JsonProperty("status")
	private int mStatusCode;

	@JsonProperty("errors")
	private Map<String, String[]> mErrors = new HashMap<>();

	@JsonSetter("errors")
	public void parseErrors(Map<String, List<Object>> errors) {
		Logger.error("parse errors: " + errors);
		if (errors == null) {
			return;
		}
		mErrors.putAll(parseErrorsMap(null, errors));

	}

	private Map<String, String[]> parseErrorsMap(String objectName, Map<String, List<Object>> errors) {
		Map<String, String[]> resultMap = new HashMap<>();

		for (Map.Entry<String, List<Object>> entry : errors.entrySet()) {
			if (entry.getValue() != null && !entry.getValue().isEmpty()) {
				if (entry.getValue().get(0) instanceof String) {
					String[] values = new String[entry.getValue().size()];
					for (int i = 0; i < entry.getValue().size(); i++) {
						values[i] = String.valueOf(entry.getValue().get(i));
					}
					String key = entry.getKey();
					if (objectName != null) {
						key = objectName + "[" + key + "]";
					}

					resultMap.put(key, values);
				} else if (entry.getValue().get(0) instanceof Map) {
					String key = entry.getKey();
					if (objectName != null) {
						key = objectName + "[" + key + "]";
					}
					for (Object map : entry.getValue()) {
						//noinspection unchecked
						resultMap.putAll(parseErrorsMap(key, (Map<String, List<Object>>) map));
					}
				}
			}
		}
		return resultMap;
	}

	@Override
	public void parse(Exception e) {
		setName("Unknown Error");
		setMessage(e.getMessage());
		setCode(RequestException.UNKNOWN);
		if (e instanceof InterruptedException) {
			setStatusCode(RequestException.INTERRUPTED);
		} else if (e instanceof TimeoutException) {
			setStatusCode(RequestException.TIMEOUT);
		} else {
			setStatusCode(RequestException.UNKNOWN);
		}
		setErrors(new HashMap<String, String[]>());
	}

	@Override
	public String getName() {
		return mName;
	}

	public void setName(String name) {
		mName = name;
	}

	@Override
	public String getMessage() {
		return mMessage;
	}

	public void setMessage(String message) {
		mMessage = message;
	}

	@Override
	public int getCode() {
		return mCode;
	}

	public void setCode(int code) {
		mCode = code;
	}

	@Override
	public int getStatusCode() {
		return mStatusCode;
	}

	@Override
	public void setStatusCode(int statusCode) {
		mStatusCode = statusCode;
	}

	@Override
	public Map<String, String[]> getErrors() {
		return mErrors;
	}

	public void setErrors(Map<String, String[]> errors) {
		mErrors = errors;
	}
}
