package com.humandevice.android.resttools.rest;

/**
 * Created by Szymon on 2016-02-01.
 * Klasa pomagająca w zarządzaniu wątkami. Blokuje/odblokowuje części kodu, jeżeli jest potrzeba wykonywały się synchronicznie.
 * Używane tylko w {@link Request#checkTokenValidity()}.
 * Uwaga: jest to singleton, nie może byc użyte jednocześnie w niezależnych częściach kodu.
 */
public class ThreadLock {

    private boolean isLocked = false;

    /**
     * Próbuje zablokować zasób. Jeżeli zasób jest aktualnie używany przez inny wątek, to czeka do momentu jego zwolnienia, a następnie
     * blokuje go dla siebie.
     * @throws InterruptedException
     */
    public synchronized void lock()
            throws InterruptedException {
        waitIfLocked();
        isLocked = true;
    }

    /**
     * Zwalnia zasób pozwalając innym wątkom na jego przejęcie. Patrz {@link Object#notify()}.
     */
    public synchronized void unlock() {
        isLocked = false;
        notify();
    }

    /**
     * Jeżeli zasób jest zablokowany to czeka do jego odblokowania.
     * @throws InterruptedException
     */
    public synchronized void waitIfLocked() throws InterruptedException {
        while (isLocked) {
            wait();
        }
    }
}
