package com.humandevice.android.resttools.adapters;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Class for storing request parameters
 *
 * @author Mikołaj Styś
 * @date 09.06.2016
 */
public class HttpParameters implements Iterable<Map.Entry<String, Object>> {

	protected HashMap<String, Object> mParameters;

	public HttpParameters() {
		mParameters = new HashMap<>();
	}

	/**
	 * Dodanie parametru do body zapytania
	 */
	public void addParameter(@Nullable Object value, @NonNull String... parameters) {
		StringBuilder nameBuilder = new StringBuilder();
		boolean first = true;
		for (String parameter : parameters) {
			if (first) {
				first = false;
				nameBuilder.append(parameter);
			} else {
				nameBuilder.append('[').append(parameter).append(']');
			}
		}
		if (RestAnnotationsHelper.isArray(value)) {
			String name = nameBuilder.toString();
			if (value instanceof Collection) {
				int i = 0;
				for (Iterator iterator = ((Collection) value).iterator(); iterator.hasNext(); ) {
					Object next = iterator.next();
					mParameters.put(name + '[' + (i++) + ']', next);
				}
			} else {
				for (int i = 0; i < ((Object[]) value).length; i++) {
					mParameters.put(name + '[' + (i) + ']', ((Object[]) value)[i]);

				}
			}
		} else {
			mParameters.put(nameBuilder.toString(), value);
		}
	}


	/**
	 * Dodanie parametru do body zapytania
	 */
	public void addParameter(HttpParameters parameters) {
		addParameter(parameters.mParameters);
	}

	/**
	 * Dodanie parametru do body zapytania
	 */
	public void addParameter(Map<String, Object> parameters) {
		mParameters.putAll(parameters);
	}

	@Override
	public Iterator<Map.Entry<String, Object>> iterator() {
		return mParameters.entrySet().iterator();
	}

	public void remove(String key) {
		mParameters.remove(key);
	}
}
