package com.humandevice.android.resttools.rest;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.android.resttools.rest.exceptions.RequestException;
import com.humandevice.android.resttools.rest.listeners.RequestListener;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 01.03.2016
 */
public class RequestFutureTask<V> extends FutureTask<V> implements RequestFuture<V> {
	@Nullable
	private final ErrorCallback mErrorCallback;
	private RequestListener<V> mListener;
	private static Handler mHandler;

	public RequestFutureTask(@NonNull Callable<V> callable, @Nullable ErrorCallback errorCallback) {
		super(callable);
		mErrorCallback = errorCallback;
	}

	public RequestFutureTask(@NonNull Callable<V> callable, @Nullable ErrorCallback errorCallback, @Nullable RequestListener<V> listener) {
		super(callable);
		mListener = listener;
		mErrorCallback = errorCallback;
	}

	@Override
	public V get() throws RequestException {
		try {
			return super.get();
		} catch (ExecutionException | InterruptedException e) {
			RequestException requestException = parseException(e);
			if (mErrorCallback != null) {
				mErrorCallback.onError(requestException);
			}
			throw requestException;
		}
	}

	@Override
	public V get(long timeout, @NonNull TimeUnit unit) throws RequestException {
		try {
			return super.get(timeout, unit);
		} catch (ExecutionException | InterruptedException | TimeoutException e) {
			throw parseException(e);
		}
	}

	@Override
	protected void done() {
		if (mListener != null) {
			getHandler().post(new Runnable() {
				@Override
				public void run() {
					mListener.done(RequestFutureTask.this);
				}
			});
		}
		super.done();
	}

	/**
	 * parsowanie błędów do {@link RequestException}
	 *
	 * @param e
	 * @return
	 */
	private RequestException parseException(Exception e) {

		Throwable cause = e.getCause();
		if (cause != null) {
			if (cause instanceof RequestException) {
				return (RequestException) cause;
			} else if (cause instanceof RuntimeException) {
				throw (RuntimeException) cause;
			}
		}
		return new RequestException(e);
	}

	public Handler getHandler() {
		if (mHandler == null) {
			mHandler = new Handler(Looper.getMainLooper());
		}
		return mHandler;
	}
}
