package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;

import com.humandevice.android.resttools.rest.exceptions.RequestException;
import com.humandevice.android.resttools.rest.listeners.PoolRequestListener;
import com.humandevice.android.resttools.rest.listeners.RequestListener;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 */
public class SerialPoolRequest extends PoolRequest<SerialPoolRequest> {

	private Map<Integer, RequestFuture> mDoneTasks = new LinkedHashMap<>();

	private Iterator<Map.Entry<Integer, Request>> mExecuteIterator;
	private Map.Entry<Integer, Request> mCurrentExecutedTask;

	public SerialPoolRequest() {
		super(1);
	}


	public void execute(PoolRequestListener listener) {
		if (mExecuted) {
			throw new IllegalStateException("Already executed.");
		}
		mExecuted = true;
		mExecuteIterator = mRequestPool.entrySet().iterator();
		mListener = listener;

		executeNext();
	}

	private void executeNext() {
		if (mExecuteIterator.hasNext()) {
			mCurrentExecutedTask = mExecuteIterator.next();
			mExecutor.submit(mCurrentExecutedTask.getValue().createRequestTask(), mIgnoreErrorCallback ? null : Request.sConfiguration.mErrorCallback, mRequestListener);
		} else {
			mExecutor.shutdown();
			if (mListener != null) {
				try {
					mListener.done(mDoneTasks);
				} catch (RequestException ignored) {
					//PoolRequestListener.fail() will be thrown
				}

			}
		}
	}

	private RequestListener mRequestListener = new RequestListener() {
		@Override
		public void done(@NonNull RequestFuture task) {
			Integer requestCode = mCurrentExecutedTask.getKey();
			try {
				task.get();
			} catch (RequestException e) {
				if (mListener != null) {
					if (mListener.fail(e, requestCode)) {
						return;
					}
				}
				if (mStopIfFail) {
					return;
				}
			}
			mDoneTasks.put(requestCode, task);
			if (mPostTaskMap.containsKey(requestCode)) {
				try {
					//noinspection unchecked
					mPostTaskMap.get(requestCode).onPost(task);
				} catch (RequestException ignored) {
					//PoolRequestListener.fail() will be thrown
				}
			}
			executeNext();
		}
	};


	public interface PostTask<T> {
		void onPost(RequestFuture<T> task) throws RequestException;
	}
}
