package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;

import com.humandevice.android.resttools.rest.exceptions.RequestException;
import com.humandevice.android.resttools.rest.listeners.RequestListener;
import com.humandevice.android.resttools.rest.listeners.PoolRequestListener;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 */
public class ThreadPoolRequest extends PoolRequest<ThreadPoolRequest> {

	private final Map<RequestFuture, Integer> mExecutedTasks = new HashMap<>();
	private final Map<Integer, RequestFuture> mDoneTasks = new LinkedHashMap<>();

	public ThreadPoolRequest(int poolSize) {
		super(poolSize);
	}

	public void execute(PoolRequestListener listener) {
		if (mExecuted) {
			throw new IllegalStateException("Already executed.");
		}
		mExecuted = true;

		mListener = listener;
		for (Map.Entry<Integer, Request> entry : mRequestPool.entrySet()) {
			mExecutedTasks.put(mExecutor.submit(entry.getValue().createRequestTask(), mIgnoreErrorCallback ? null : Request.sConfiguration.mErrorCallback, mRequestListener), entry.getKey());
		}
		mExecutor.shutdown();
	}

	private RequestListener mRequestListener = new RequestListener() {
		@Override
		public void done(@NonNull RequestFuture task) {
			Integer requestCode = mExecutedTasks.get(task);
			try {
				task.get();
			} catch (RequestException e) {
				if (mListener != null) {
					if (mListener.fail(e, requestCode)) {
						stopExecute();
						return;
					}
				}
				if (mStopIfFail) {
					stopExecute();
					return;
				}
			}

			mDoneTasks.put(requestCode, task);
			if (mPostTaskMap.containsKey(requestCode)) {
				try {
					//noinspection unchecked
					mPostTaskMap.get(requestCode).onPost(task);
				} catch (RequestException ignored) {
					//PoolRequestListener.fail() will be thrown
				}
			}

			if (mDoneTasks.size() == mExecutedTasks.size()){
				if (mListener != null) {
					try {
						mListener.done(mDoneTasks);
					} catch (RequestException ignored) {
						//PoolRequestListener.fail() will be thrown
					}
				}
			}
		}
	};

}
