package com.humandevice.android.resttools.service;

import com.humandevice.android.resttools.model.Token;
import com.humandevice.android.resttools.rest.exceptions.RefreshTokenException;

/**
 * Intefejs zapewniający podstawowe metody IUserService. <br /><br /> <b>NOTE: </b>Klasa implemenująca ten interface musi posiadać statyczną metodę getInstance();
 *
 * @author Szymon Bartczak
 * @date 2016-05-04
 */
public interface IUserService {

    /**
     * @return true jeśli użytkownik akutalnie jest zalogowany.
     */
    boolean isLogged();

    /**
     * @return true jeżeli token uwierzytelniający wciąż jest poprawny tzn. czy np. nie wygasł.
     */
    boolean isTokenValid();

    /**
     * Próbuje odświeżyć token uwierzytelniający.
     * @throws RefreshTokenException jeżeli wystąpił błąd podczas odświeżania.
     */
    void refreshToken() throws RefreshTokenException;

    /**
     * @return token uwierzytelniający.
     */
    Token getToken();

    /**
     * Wylogowuje użytkownika, czyszcząc przy tym zapamiętane tokeny.
     */
    void logout();
}
