package com.humandevice.android.resttools.rest.listeners;

import android.support.annotation.NonNull;

import com.humandevice.android.resttools.rest.RequestFuture;

/**
 * Listener zapytania do api, uruchamiany jest w momencie zakończenia zadania
 *
 * @author Rafal Zajfert
 * @date 29.02.2016
 */
public interface RequestListener<T> {
    /**
     * Metoda wywoływana po zakończeniu wykonywania zadania
     * @param task zadanie, które zostało ukończone oraz z którego może zostać odczytany wynik
     */
    void done(@NonNull RequestFuture<T> task);

}