package com.humandevice.android.resttools.adapters;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.humandevice.android.resttools.rest.exceptions.ParseException;
import com.rafalzajfert.androidlogger.Logger;

import java.lang.reflect.Field;

import static com.humandevice.android.resttools.adapters.RestAnnotationsHelper.getAllFields;
import static com.humandevice.android.resttools.adapters.RestAnnotationsHelper.getEnumRestName;
import static com.humandevice.android.resttools.adapters.RestAnnotationsHelper.getRestName;
import static com.humandevice.android.resttools.adapters.RestAnnotationsHelper.hasRestObjectAnnotation;

/**
 * Reflect inmplementation of {@link HttpUrlEncodedSerializer}
 * Date: 2016/01/28
 *
 * @author Mikołaj Styś
 */
public class ReflectHttpUrlEncodedSerializer<Model> implements HttpUrlEncodedSerializer<Model> {

    private final String mParameterName;

    public ReflectHttpUrlEncodedSerializer(@Nullable String parameterName) {
        mParameterName = parameterName;
    }

    @Override
    public HttpParameters serializeModel(Model model, @Nullable HttpParameters form) throws ParseException {
        if (form == null) {
            form = new HttpParameters();
        }
        try {
            String[] params;
            if (!TextUtils.isEmpty(mParameterName)) {
                params = new String[]{mParameterName};
            } else {
                params = new String[0];
            }
            addClassToForm(params, model, form);
        } catch (IllegalAccessException e) {
            Logger.warning(e);
            throw new ParseException();
        } catch (NoSuchFieldException e) {
            Logger.warning(e);
            throw new ParseException();
        }
        return form;
    }

    protected void addClassToForm(String[] outerObjects, Object outerValue, HttpParameters form) throws IllegalAccessException, NoSuchFieldException {
        if (outerValue == null){
            return;
        }
        if (!hasRestObjectAnnotation((outerValue.getClass()))) {
            form.addParameter(outerValue, outerObjects);
            return;
        }
        for (Field field : getAllFields(outerValue.getClass())) {
            field.setAccessible(true);
            String restParameterName = getRestName(field);
            if (!TextUtils.isEmpty(restParameterName)) {

                String[] innerObjects = new String[outerObjects.length + 1];
                innerObjects[outerObjects.length] = restParameterName;
                System.arraycopy(outerObjects, 0, innerObjects, 0, outerObjects.length);

                Object innerValue = field.get(outerValue);

                if (innerValue != null) {
                    if (hasRestObjectAnnotation((innerValue.getClass()))) {
                        addClassToForm(innerObjects, innerValue, form);
                    } else {
                        if (innerValue instanceof Enum<?>) {
                            String enumValue = getEnumRestName(field, outerValue);
                            if (!TextUtils.isEmpty(enumValue)) {
                                innerValue = enumValue;
                            }
                        }
                        form.addParameter(innerValue, innerObjects);
                    }
                }

            }
            field.setAccessible(false);
        }
    }
}
