package com.humandevice.android.resttools.adapters;

import android.support.annotation.Nullable;

import com.humandevice.android.core.adapters.Serialized;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static com.humandevice.android.core.adapters.Serialized.EMPTY;

/**
 * Helps extracting annotations values
 * Date: 2016/01/28
 *
 * @author Mikołaj Styś
 */
public final class RestAnnotationsHelper {

    private RestAnnotationsHelper() {

    }

    private static boolean isSet(final String name) {
        return !EMPTY.equals(name);
    }

    private static boolean isNotSet(final String name) {
        return EMPTY.equals(name);
    }

    @Nullable
    public static String getRestName(final Field field) {
        Serialized annotation = field.getAnnotation(Serialized.class);
        if (annotation == null) {
            return null;
        } else if (isSet(annotation.value())) {
            return annotation.value();
        } else if (isSet(annotation.rest())) {
            return annotation.rest();
        } else if (field.isEnumConstant() || (isNotSet(annotation.database()) && isNotSet(annotation.view()))) {
            return field.getName();
        } else {
            return null;
        }
    }

    private static Field getEnumField(Field field, Object model) throws NoSuchFieldException, IllegalAccessException {
        String result = ((Enum<?>) field.get(model)).name();
        return field.getType().getField(result);
    }

    @Nullable
    public static String getEnumRestName(Field field, Object model) throws IllegalAccessException, NoSuchFieldException {
        return getRestName(getEnumField(field, model));
    }

    public static List<Field> getAllFields(Class<?> entityClass) {
        List<Field> result = new ArrayList<>();
        Class<?> i = entityClass;
        while (i != null && i != Object.class) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
            i = i.getSuperclass();
        }
        return result;
    }

    public static boolean isArray(@Nullable Object value) {
        return value != null && (value instanceof Collection || value.getClass().isArray());
    }


    public static boolean hasRestObjectAnnotation(Class<?> cls) {
        return cls.getAnnotation(RestObject.class) != null;
    }
}
