package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;

import com.rafalzajfert.androidlogger.Logger;

import java.io.IOException;

import okhttp3.HttpUrl;
import okhttp3.Response;

/**
 * Klasa obsługująca połączenie z Api metodą GET
 *
 * @author Rafal Zajfert
 * @date 07.01.2016
 * @see Request
 */
public abstract class GetRequest<E> extends Request<E> {

    protected GetRequest() {
    }

    @Override
    protected Response request() throws IOException {
        Logger.info("= GET =============================");
        HttpUrl url = getUrl();
        Logger.info(url);
        Logger.info("===================================");

        okhttp3.Request request = createRequest(url);

        return mHttpClient.newCall(request).execute();
    }

    @Override
    protected void putParameter(@NonNull String name, Object value) {
        super.putUrlParameter(name, value);
    }

    /**
     * Metoda tworząca request na podstawie {@code url}
     * @param url adres url, do którego ma zostać wysłane zapytanie
     * @return gotowy request do wysłania
     */
    @NonNull
    private okhttp3.Request createRequest(HttpUrl url) {
        return new okhttp3.Request.Builder()
                .url(url)
                .get().build();
    }
}
