package com.humandevice.android.resttools.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.rafalzajfert.androidlogger.Logger;

import java.io.IOException;

import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Klasa obsługująca połączenie z api metodą POST
 *
 * @see Request
 * @date 07.01.2016
 * @author Rafal Zajfert
 */
public abstract class PostRequest<T> extends Request<T> {

    protected PostRequest() {
    }

    @Override
    protected Response request() throws IOException {
        Logger.info("= POST ============================");
        HttpUrl url = getUrl();
        Logger.info(url);
        RequestBody body = getRequestBody();
        Logger.info("===================================");

        okhttp3.Request request = createRequest(url, body);

        return mHttpClient.newCall(request).execute();
    }

    /**
     * Metoda tworząca request na podstawie {@code url} oraz {@code body}
     * @param url adres url, do którego ma zostać wysłane zapytanie
     * @param body ciało zapytania, które ma zostać wysłane
     * @return gotowy request do wysłania
     */
    @NonNull
    private okhttp3.Request createRequest(@NonNull HttpUrl url, @Nullable RequestBody body) {
        return new okhttp3.Request.Builder()
                .url(url)
                .addHeader(CONTENT_TYPE, isMultipartRequest ? MULTIPART_MEDIA_TYPE.toString() : MEDIA_TYPE.toString())
                .post(body).build();
    }

}
