package com.humandevice.android.stringtools.stringtools.styles;

import android.graphics.Typeface;
import android.text.style.StyleSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building bold Strings.
 *
 * @author Wojtek Kolendo
 * @date 24.08.2016
 */

public class SpannableStringBold extends CustomSpannableString {

	public SpannableStringBold() {
		super();
	}

	public SpannableStringBold(CharSequence text) {
		super(text, new StyleSpan(Typeface.BOLD));
	}

	public SpannableStringBold appendBold(CharSequence csq) {
		appendStyled(csq, new StyleSpan(Typeface.BOLD));
		return this;
	}
}
