package com.humandevice.android.stringtools.stringtools.styles;

import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.text.style.BackgroundColorSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building Strings with colored background.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringColorBg extends CustomSpannableString {

	public SpannableStringColorBg() {
		super();
	}

	public SpannableStringColorBg(CharSequence text) {
		super(text);
	}

	public SpannableStringColorBg(CharSequence text, @ColorRes int colorRes) {
		appendStyled(text, new BackgroundColorSpan(getColor(colorRes)));
	}

	public SpannableStringColorBg appendColorBg(CharSequence csq, @ColorRes int colorRes) {
		appendStyled(csq, new BackgroundColorSpan(getColor(colorRes)));
		return this;
	}

	private int getColor(@ColorRes int colorRes) {
		return ContextCompat.getColor(getContext(), colorRes);
	}
}
