package com.humandevice.android.stringtools.stringtools.styles;

import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import android.text.style.ImageSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building String with image within.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringImage extends CustomSpannableString {

	public SpannableStringImage() {
		super();
	}

	public SpannableStringImage(Drawable drawable) {
		appendStyled(" ", new ImageSpan(drawable, DynamicDrawableSpan.ALIGN_BOTTOM));
	}

	public SpannableStringImage appendImage(Drawable drawable) {
		appendStyled(" ", new ImageSpan(drawable, DynamicDrawableSpan.ALIGN_BOTTOM));
		return this;
	}
}
