package com.humandevice.android.stringtools.stringtools.styles;

import android.text.style.AbsoluteSizeSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building Strings with specific size.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */
public class SpannableStringSize extends CustomSpannableString {

	public SpannableStringSize() {
		super();
	}

	public SpannableStringSize(CharSequence text) {
		super(text);
	}

	public SpannableStringSize(CharSequence text, int size) {
		super(text, new AbsoluteSizeSpan(size, true));
	}

	public SpannableStringSize appendSize(CharSequence csq, int size) {
		appendStyled(csq, new AbsoluteSizeSpan(size, true));
		return this;
	}

}
