package com.humandevice.android.stringtools.stringtools;

import android.app.Application;
import android.content.Context;
import android.text.Spannable;
import android.text.SpannableStringBuilder;

/**
 * Main class for customized Spannable Strings.
 * Extend it and invoke appendStyled in a new class.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class CustomSpannableString extends SpannableStringBuilder {

	public CustomSpannableString(){
		super();
	}

	public CustomSpannableString(CharSequence text) {
		super(text);
	}

	protected CustomSpannableString(CharSequence text, Object style) {
		super();
		appendStyled(text, style);
	}

	protected void appendStyled(CharSequence csq, Object style) {
		int start = length();
		append(csq);
		if (style != null) {
			setSpan(style,
					start,
					length(),
					Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
		}
	}

	protected void appendStyled(CharSequence csq, Object style, int start, int end, int flags) {
		append(csq);
		if (style != null) {
			setSpan(style,
					start,
					end,
					flags);
		}
	}

	protected Context getContext() {
		try {
			Application application = (Application) Class.forName("android.app.ActivityThread").getMethod("currentApplication").invoke(null, (Object[]) null);
			return application.getApplicationContext();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
}
