package com.humandevice.android.stringtools.stringtools.styles;

import android.app.Application;
import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

import java.util.ArrayList;
import java.util.List;

/**
 * Class for building colored Strings.
 *
 * @author Wojtek Kolendo
 * @date 24.08.2016
 */

public class SpannableStringColor extends CustomSpannableString {

	public SpannableStringColor() {
		super();
	}

	public SpannableStringColor(CharSequence text) {
		super(text);
	}

	public SpannableStringColor(CharSequence text, @ColorRes int colorRes) {
		appendStyled(text, new ForegroundColorSpan(getColor(colorRes)));
	}

	public SpannableStringColor appendColor(CharSequence csq, @ColorRes int colorRes) {
		appendStyled(csq, new ForegroundColorSpan(getColor(colorRes)));
		return this;
	}

	private int getColor(@ColorRes int colorRes) {
		return ContextCompat.getColor(getContext(), colorRes);
	}
}
