package com.humandevice.android.stringtools.stringtools.styles;

import android.graphics.Typeface;
import android.text.style.StyleSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building italic Strings.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringItalic extends CustomSpannableString {

	public SpannableStringItalic() {
		super();
	}

	public SpannableStringItalic(CharSequence text) {
		super(text, new StyleSpan(Typeface.ITALIC));
	}

	public SpannableStringItalic appendItalic(CharSequence csq) {
		appendStyled(csq, new StyleSpan(Typeface.ITALIC));
		return this;
	}
}
