package com.humandevice.android.stringtools.stringtools.styles;

import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building crossed out text.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringStrikethrough extends CustomSpannableString {

	public SpannableStringStrikethrough() {
		super();
	}

	public SpannableStringStrikethrough(CharSequence text) {
		super(text, new StrikethroughSpan());
	}

	public SpannableStringStrikethrough appendStrikethrough(CharSequence csq) {
		appendStyled(csq, new StrikethroughSpan());
		return this;
	}
}
