package com.humandevice.android.stringtools.stringtools.styles;

import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.text.style.StyleSpan;
import android.text.style.TextAppearanceSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building Strings with specific style.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringStyled extends CustomSpannableString {

	public SpannableStringStyled() {
		super();
	}

	public SpannableStringStyled(CharSequence text, @StyleRes int styleRes) {
		appendStyled(text, new TextAppearanceSpan(getContext(), styleRes));
	}

	public SpannableStringStyled appendBold(CharSequence csq, @StyleRes int styleRes) {
		appendStyled(csq, new TextAppearanceSpan(getContext(), styleRes));
		return this;
	}

}
