package com.humandevice.android.stringtools.stringtools.styles;

import android.graphics.Typeface;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;

import com.humandevice.android.stringtools.stringtools.CustomSpannableString;

/**
 * Class for building underlined Strings.
 *
 * @author Wojtek Kolendo
 * @date 26.08.2016
 */

public class SpannableStringUnderline extends CustomSpannableString {

	public SpannableStringUnderline() {
		super();
	}

	public SpannableStringUnderline(CharSequence text) {
		super(text, new UnderlineSpan());
	}

	public SpannableStringUnderline appendUnderline(CharSequence csq) {
		appendStyled(csq, new UnderlineSpan());
		return this;
	}
}
