package com.humandevice.android.stringtools.stringtools;

import android.text.style.SubscriptSpan;

/**
 * Class for building subscripted Strings.
 *
 * @author Wojtek Kolendo
 */

public class SpannableSubscript extends StyledSpannableString {

	//region Constructors
	public SpannableSubscript() {
		super();
	}

	public SpannableSubscript(CharSequence text) {
		this(text, true);
	}

	public SpannableSubscript(CharSequence text, boolean subscript) {
		if (subscript) {
			appendSubscript(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableSubscript appendSubscript(CharSequence text) {
		appendStyled(text, new SubscriptSpan());
		return this;
	}
	//endregion
}
