package com.humandevice.android.stringtools.stringtools;

import android.text.style.UnderlineSpan;

/**
 * Class for building underlined Strings.
 *
 * @author Wojtek Kolendo
 */

public class SpannableUnderline extends StyledSpannableString {

	//region Constructors
	public SpannableUnderline() {
		super();
	}

	public SpannableUnderline(CharSequence text) {
		this(text, true);
	}

	public SpannableUnderline(CharSequence text, boolean underline) {
		if (underline) {
			appendUnderline(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableUnderline appendUnderline(CharSequence text) {
		appendStyled(text, new UnderlineSpan());
		return this;
	}
	//endregion
}
