package com.humandevice.android.stringtools.stringtools;

import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;

/**
 * Main class for customized Spannable Strings.
 * Extend it and invoke appendStyled in a new class.
 *
 * @author Wojtek Kolendo
 */

class StyledSpannableString extends SpannableStringBuilder {

	private static Context sContext;

	StyledSpannableString(){
		super();
	}

	StyledSpannableString(CharSequence text) {
		super(text);
	}

	StyledSpannableString(CharSequence text, Object style) {
		super();
		appendStyled(text, style);
	}

	void appendStyled(CharSequence text, Object style) {
		int length = length();
		appendStyled(text, style, length, length + text.length(), Spannable.SPAN_INCLUSIVE_EXCLUSIVE);
	}

	void appendStyled(CharSequence text, Object style, int start, int end, int flags) {
		append(text);
		if (style != null) {
			setSpan(style, start, end, flags);
		}
	}

	static Context getContext() {
		if (sContext == null){
			sContext = getReflectContext();
		}
		return sContext;
	}

	@Nullable
	private static Context getReflectContext() {
		try {
			return ((Application) Class.forName("android.app.ActivityThread").getMethod("currentApplication").invoke(null, (Object[]) null)).getApplicationContext();
		} catch (Exception e) {
			return null;
		}
	}
}
