package com.humandevice.android.stringtools.stringtools;

import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.text.style.BackgroundColorSpan;

/**
 * Class for building Strings with colored background.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableBackground extends StyledSpannableString {

	//region Constructors
	public SpannableBackground() {
		super();
	}

	public SpannableBackground(CharSequence text) {
		super(text);
	}

	public SpannableBackground(CharSequence text, @ColorInt int color) {
		appendBackgroundColor(text, color);
	}
	//endregion

	//region Append methods
	public SpannableBackground appendBackgroundColorRes(CharSequence text, @ColorRes int colorId) {
		appendStyled(text, new BackgroundColorSpan(getColor(colorId)));
		return this;
	}

	public SpannableBackground appendBackgroundColor(CharSequence text, @ColorInt int color) {
		appendStyled(text, new BackgroundColorSpan(color));
		return this;
	}
	//endregion

	private static int getColor(@ColorRes int colorId) {
		return ContextCompat.getColor(getContext(), colorId);
	}
}
