package com.humandevice.android.stringtools.stringtools;

import android.graphics.Typeface;
import android.text.style.StyleSpan;

/**
 * Class for building bold Strings.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableBold extends StyledSpannableString {

	//region Constructors
	public SpannableBold() {
		super();
	}

	public SpannableBold(CharSequence text) {
		this(text, true);
	}

	public SpannableBold(CharSequence text, boolean bold) {
		if (bold){
			appendBold(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableBold appendBold(CharSequence text) {
		appendStyled(text, new StyleSpan(Typeface.BOLD));
		return this;
	}
	//endregion
}
