package com.humandevice.android.stringtools.stringtools;

import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.text.style.ForegroundColorSpan;

/**
 * Class for building colored Strings.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableColor extends StyledSpannableString {

	//region Constructors
	public SpannableColor() {
		super();
	}

	public SpannableColor(CharSequence text) {
		super(text);
	}

	public SpannableColor(CharSequence text, @ColorInt int color) {
		appendStyled(text, new ForegroundColorSpan(color));
	}
	//endregion

	//region Append methods
	public SpannableColor appendColor(CharSequence text, @ColorInt int color) {
		appendStyled(text, new ForegroundColorSpan(color));
		return this;
	}

	public SpannableColor appendColorRes(CharSequence text, @ColorRes int colorId) {
		return appendColor(text, getColor(colorId));
	}
	//endregion

	private static int getColor(@ColorRes int colorId) {
		return ContextCompat.getColor(getContext(), colorId);
	}
}
