package com.humandevice.android.stringtools.stringtools;

import android.graphics.Typeface;
import android.text.style.StyleSpan;

/**
 * Class for building italic Strings.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableItalic extends StyledSpannableString {

	//region Constructors
	public SpannableItalic() {
		super();
	}

	public SpannableItalic(CharSequence text) {
		this(text, true);
	}

	public SpannableItalic(CharSequence text, boolean italic) {
		if (italic) {
			appendItalic(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableItalic appendItalic(CharSequence text) {
		appendStyled(text, new StyleSpan(Typeface.ITALIC));
		return this;
	}
	//endregion
}
