package com.humandevice.android.stringtools.stringtools;

import android.text.style.AbsoluteSizeSpan;

/**
 * Class for building Strings with specific size.
 *
 * @author Wojtek Kolendo
 */
public class SpannableSize extends StyledSpannableString {

	//region Constructors
	public SpannableSize() {
		super();
	}

	public SpannableSize(CharSequence text) {
		super(text);
	}

	public SpannableSize(CharSequence text, int size) {
		this(text, size, true);
	}

	public SpannableSize(CharSequence text, int size, boolean dip) {
		super(text, new AbsoluteSizeSpan(size, dip));
	}
	//endregion

	//region Append methods
	public SpannableSize appendSize(CharSequence text, int size) {
		return appendSize(text, size, true);
	}

	public SpannableSize appendSize(CharSequence text, int size, boolean dip) {
		appendStyled(text, new AbsoluteSizeSpan(size, dip));
		return this;
	}
	//endregion

}
