package com.humandevice.android.stringtools.stringtools;

import android.text.style.StrikethroughSpan;

/**
 * Class for building crossed out text.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableStrikeThrough extends StyledSpannableString {

	//region Constructors
	public SpannableStrikeThrough() {
		super();
	}

	public SpannableStrikeThrough(CharSequence text) {
		this(text, true);
	}

	public SpannableStrikeThrough(CharSequence text, boolean strikeThrough) {
		if (strikeThrough) {
			appendStrikeThrough(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableStrikeThrough appendStrikeThrough(CharSequence text) {
		appendStyled(text, new StrikethroughSpan());
		return this;
	}
	//endregion
}
