package com.humandevice.android.stringtools.stringtools;

import android.support.annotation.StyleRes;
import android.text.style.TextAppearanceSpan;

/**
 * Class for building Strings with specific style.
 *
 * @author Wojtek Kolendo
 */
@SuppressWarnings("unused")
public class SpannableStyle extends StyledSpannableString {

	//region Constructors
	public SpannableStyle() {
		super();
	}

	public SpannableStyle(CharSequence text, @StyleRes int styleId) {
		appendStyled(text, new TextAppearanceSpan(getContext(), styleId));
	}
	//endregion

	//region Append methods
	public SpannableStyle appendStyle(CharSequence text, @StyleRes int styleId) {
		appendStyled(text, new TextAppearanceSpan(getContext(), styleId));
		return this;
	}
	//endregion

}
