package com.humandevice.android.stringtools.stringtools;

import android.text.style.SuperscriptSpan;

/**
 * Class for building superscripted Strings.
 *
 * @author Wojtek Kolendo
 */

public class SpannableSuperscript extends StyledSpannableString {

	//region Constructors
	public SpannableSuperscript() {
		super();
	}

	public SpannableSuperscript(CharSequence text) {
		this(text, true);
	}

	public SpannableSuperscript(CharSequence text, boolean superscript) {
		if (superscript) {
			appendSuperscript(text);
		} else {
			append(text);
		}
	}
	//endregion

	//region Append methods
	public SpannableSuperscript appendSuperscript(CharSequence text) {
		appendStyled(text, new SuperscriptSpan());
		return this;
	}
	//endregion

}
