package com.humandevice.validator.rules;

import android.text.TextUtils;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.utils.ValidatorUtils;
import com.humandevice.validator.widget.ValidatorView;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class LengthRule extends Rule<LengthRule> {

    private Integer min;
    private Integer max;

    private boolean allowEmpty = false;

    public LengthRule(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void checkView(ValidatorView view) throws ValidationException {
        String text = (String) ValidatorUtils.getValue(view);
        if (!(allowEmpty && TextUtils.isEmpty(text)) && ValidatorUtils.isShorter(text, min) || ValidatorUtils.isLonger(text, max)) {
            throw new ValidationException(view, message);
        }
    }

    public LengthRule allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
        if (!ValidatorUtils.isTextView(view)) {
            throw new IllegalArgumentException("View must extends TextView instead of " + view.getClass().getSimpleName());
        }
    }
}
