package com.humandevice.validator.errors;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
@SuppressWarnings("unused")
public class Errors {

	private List<ValidationError> mErrors = new ArrayList<>();

	/**
	 * @return List of all mErrors
	 */
	@NonNull
	public List<ValidationError> getAllErrors() {
		return mErrors;
	}

	/**
	 * Add new {@link ValidationError} to the list
	 */
	public void add(@NonNull ValidationError error) {
		mErrors.add(error);
	}

	public void addAll(Errors errors) {
		for (ValidationError error : errors.getAllErrors()) {
			mErrors.add(error);
		}
	}

	public void addAll(List<ValidationError> errors) {
		mErrors.addAll(errors);
	}

	/**
	 * Remove all mErrors
	 */
	public void clear() {
		mErrors.clear();
	}

	/**
	 * Removes all mErrors for the specified field
	 */
	public void remove(ValidationError error) {
		mErrors.remove(error);
	}

	/**
	 * Check if the error list isEmpty
	 */
	public boolean hasErrors() {
		return !mErrors.isEmpty();
	}

	/**
	 * Returns concatenated mErrors messages. Each error is separated with new line
	 */
	@NonNull
	public String getCombinedMessage() {
		return getCombinedMessage("\n");
	}

	/**
	 * Returns concatenated mErrors messages. Each error is separated with new line
	 */
	@NonNull
	public String getCombinedMessage(String separator) {
		StringBuilder builder = new StringBuilder();
		for (ValidationError error : mErrors) {
			if (builder.length() > 0) {
				builder.append(separator);
			}
			builder.append(error.getMessage());
		}
		return builder.toString();
	}

	/**
	 * Returns concatenated mErrors messages. Each error is separated with new line
	 */
	@NonNull
	public String getCombinedMessageWithName(String name) {
		return getCombinedMessageWithName(name, "\n");
	}

	/**
	 * Returns concatenated mErrors messages. Each error is separated with new line
	 */
	@NonNull
	public String getCombinedMessageWithName(String name, String separator) {
		StringBuilder builder = new StringBuilder();
		for (ValidationError error : mErrors) {
			if (error.getFieldName().equals(name)) {
				if (builder.length() > 0) {
					builder.append(separator);
				}
				builder.append(error.getMessage());
			}
		}
		return builder.toString();
	}

	public Set<String> getFieldNamesWithErrors(){
		Set<String> names = new LinkedHashSet<>();
		for (ValidationError error : mErrors) {
			names.add(error.getFieldName());
		}
		return names;
	}

	public List<ValidationError> getErrorsForName(String name){
		List<ValidationError> errors = new ArrayList<>();
		for (ValidationError error : mErrors) {
			if (error.getFieldName().equals(name)){
				errors.add(error);
			}
		}
		return errors;
	}

	/**
	 * @return Errors count for all views
	 */
	public int count() {
		return mErrors.size();
	}
}
