package com.humandevice.validator.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.v7.widget.AppCompatCheckBox;
import android.util.AttributeSet;

import com.humandevice.validator.R;
import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.rules.Rule;

import java.util.Set;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
public class ValidatorCheckBox extends AppCompatCheckBox implements ValidatorView {

	private ValidatorViewDelegator mDelegator = new ValidatorViewDelegator();

	public ValidatorCheckBox(Context context) {
		super(context);
	}

	public ValidatorCheckBox(Context context, AttributeSet attrs) {
		super(context, attrs);
		parseAttrs(context, attrs);
	}

	public ValidatorCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		parseAttrs(context, attrs);
	}

	protected void parseAttrs(Context context, AttributeSet attrs) {
		TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ValidatorView, 0, 0);
		try {
			setName(a.getString(R.styleable.ValidatorView_name));
		} finally {
			a.recycle();
		}
	}

	@Override
	public void setName(String name) {
		mDelegator.setName(name);
	}

	@Override
	public String getName() {
		return mDelegator.getName();
	}

	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		mDelegator.addRule(rule, otherRules);
	}

	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		mDelegator.addRules(rules);
	}

	@Override
	public Set<Rule> getRules() {
		return mDelegator.getRules();
	}

	@Override
	public boolean validate(int maxPriority) {
		return mDelegator.validate(this, maxPriority);
	}

	@Override
	public Errors getErrors() {
		return mDelegator.getErrors();
	}

	@Override
	public boolean hasErrors() {
		return mDelegator.hasErrors();
	}

	@Override
	public void clearErrors() {
		mDelegator.clearErrors();
	}

	@Override
	public void showErrors() {
		mDelegator.showErrors(this);
	}

}
