package com.humandevice.validator.errors;

import android.support.annotation.NonNull;

import com.humandevice.validator.widget.ValidatorView;

/**
 * Created by Rafal Zajfert on 06.11.2015.
 */
public class ValidationException extends Exception {
    @NonNull
    private ValidationError mValidationError;

    public ValidationException(@NonNull ValidationError validationError) {
        mValidationError = validationError;
    }

    public ValidationException(ValidatorView view, String message) {
        this(-1, view, message);
    }

    public ValidationException(int code, ValidatorView view, String message) {
        this(code, view.getName(), message);
    }

    public ValidationException(String fieldName, String message) {
        this(-1, fieldName, message);
    }

    public ValidationException(int code, String fieldName, String message) {
        this(new ValidationError(code, fieldName, message));
    }

    @NonNull
    public ValidationError getValidationError() {
        return mValidationError;
    }
}
