package com.humandevice.validator.rules;

import android.support.annotation.NonNull;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.widget.ValidatorView;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class CustomRule extends Rule<CustomRule> {

    private RuleChecker mRuleChecker;

    public CustomRule(@NonNull RuleChecker ruleChecker) {
        this.mRuleChecker = ruleChecker;
    }

    @Override
    protected void checkView(ValidatorView view) throws ValidationException {
        if (!mRuleChecker.isValid(view)) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
    }

    public interface RuleChecker {

        /**
         * Method should check if value of the view is valid or not
         *
         * @param view View associated with this rule
         * @return true if value is valid, false otherwise
         */
        boolean isValid(ValidatorView view);
    }
}