package com.humandevice.validator.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.ViewParent;
import android.widget.EditText;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class ErrorTextWatcher implements TextWatcher {

	@Nullable
	protected EditText mTextView;

	@Nullable
	protected TextInputLayout mTextInputLayout;

	public ErrorTextWatcher(@NonNull EditText textView) {
		mTextView = textView;
	}

	public ErrorTextWatcher(@NonNull TextInputLayout textInputLayout) {
		mTextInputLayout = textInputLayout;
	}


	@Override
	public void beforeTextChanged(CharSequence s, int start, int count, int after) {
	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count) {
	}

	@Override
	public void afterTextChanged(Editable s) {
		if (mTextView != null) {
			mTextView.setError(null);
			ViewParent parent=mTextView.getParent().getParent();
			if(parent instanceof TextInputLayout){
				((TextInputLayout)parent).setError(null);
				((TextInputLayout)parent).setErrorEnabled(false);
			}
		} else if (mTextInputLayout != null) {
			mTextInputLayout.setError(null);
			mTextInputLayout.setErrorEnabled(false);
			EditText editText = mTextInputLayout.getEditText();
			if (editText != null) {
				editText.setError(null);
			}
		}

	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof ErrorTextWatcher && mTextView != null) {
			return mTextView.equals(((ErrorTextWatcher) o).mTextView);
		} else if (o instanceof ErrorTextWatcher && mTextInputLayout != null) {
			return mTextInputLayout.equals(((ErrorTextWatcher) o).mTextInputLayout);
		} else {
			return super.equals(o);
		}
	}

	@Override
	public int hashCode() {
		if (mTextView != null) {
			return mTextView.hashCode();
		} else if (mTextInputLayout != null) {
			return mTextInputLayout.hashCode();
		}
		return super.hashCode();
	}
}