package com.humandevice.validator.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.design.widget.TextInputLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;

import com.humandevice.validator.R;
import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.rules.Rule;
import com.humandevice.validator.utils.ErrorTextWatcher;

import java.util.Set;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
public class ValidatorTextInputLayout extends TextInputLayout implements ValidatorView {
	
	private ValidatorViewDelegator mDelegator = new ValidatorViewDelegator();
	
	public ValidatorTextInputLayout(Context context) {
		super(context);
	}
	
	public ValidatorTextInputLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
		parseAttrs(context, attrs);
	}
	
	public ValidatorTextInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		parseAttrs(context, attrs);
	}
	
	protected void parseAttrs(Context context, AttributeSet attrs) {
		TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ValidatorView, 0, 0);
		try {
			setName(a.getString(R.styleable.ValidatorView_name));
		} finally {
			a.recycle();
		}
	}
	
	@Override
	public void setName(String name) {
		mDelegator.setName(name);
	}
	
	@Override
	public String getName() {
		EditText editText = getEditText();
		if (TextUtils.isEmpty(mDelegator.getName()) && (editText != null && editText instanceof ValidatorView)) {
			return ((ValidatorView) editText).getName();
		}
		return mDelegator.getName();
	}
	
	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		mDelegator.addRule(rule, otherRules);
		initTextWatcher();
	}
	
	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		mDelegator.addRules(rules);
		initTextWatcher();
	}
	
	@Override
	public void addView(View child) {
		super.addView(child);
		initTextWatcher();
		
	}
	
	@Override
	public Set<Rule> getRules() {
		
		EditText editText = getEditText();
		if (mDelegator.getRules().isEmpty() && (editText != null && editText instanceof ValidatorView)) {
			return ((ValidatorView) editText).getRules();
		}
		return mDelegator.getRules();
	}
	
	@Override
	public boolean validate(int maxPriority) {
		return mDelegator.validate(this, maxPriority);
	}
	
	@Override
	public Errors getErrors() {
		return mDelegator.getErrors();
	}
	
	@Override
	public boolean hasErrors() {
		return mDelegator.hasErrors();
	}
	
	@Override
	public void clearErrors() {
		mDelegator.clearErrors();
	}
	
	@Override
	public void showErrors() {
		if (mDelegator.hasErrors()) {
			setError(mDelegator.getErrors().getCombinedMessage());
			setErrorEnabled(true);
		} else {
			
			setError(null);
			setErrorEnabled(false);
		}
	}
	
	protected void initTextWatcher() {
		ErrorTextWatcher textWatcher = new ErrorTextWatcher(this);
		EditText editText = getEditText();
		if (editText != null) {
			editText.removeTextChangedListener(textWatcher);
			editText.addTextChangedListener(textWatcher);
		}
		
	}
	
	/**
	 * fix do błędu inicjalizacji layoutu z wyglądem erroru
	 */
	private void clearErrorsFix() {
		setError(" ");
		setErrorEnabled(false);
	}
	
	@Override
	protected void onAttachedToWindow() {
		super.onAttachedToWindow();
		clearErrorsFix();
	}
	
}
