package com.humandevice.validator.rules;

import android.support.annotation.NonNull;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.utils.ValidatorUtils;
import com.humandevice.validator.widget.ValidatorView;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class CheckedRule extends Rule<CheckedRule> {

    public CheckedRule() {
    }

    @Override
    public void checkView(@NonNull ValidatorView view) throws ValidationException {
        Object value = ValidatorUtils.getValue(view);
        if (value != null && value instanceof Boolean && !((Boolean) value)) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
        if (!ValidatorUtils.isCheckableView(view)) {
            throw new IllegalArgumentException("View must extends CompoundButton");
        }
    }
}
