package com.humandevice.validator.rules;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.utils.ValidatorUtils;
import com.humandevice.validator.widget.ValidatorView;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class EqualsRule extends Rule<EqualsRule> {


    private final Object mValue;

    public EqualsRule(@NonNull ValidatorView view) {
        this.mValue = view;
    }

    public EqualsRule(@Nullable Object value) {
        this.mValue = value;
    }

    @Override
    public void checkView(@NonNull ValidatorView view) throws ValidationException {
        Object value = ValidatorUtils.getValue(view);
        Object otherValue = getOtherValue(this.mValue);

        if (!isEqual(value, otherValue)) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
    }

    private Object getOtherValue(Object value) {
        Object otherValue;
        if (value instanceof ValidatorView) {
            otherValue = ValidatorUtils.getValue((ValidatorView) mValue);
        } else {
            otherValue = mValue;
        }
        return otherValue;
    }

    protected boolean isEqual(Object value1, Object value2) {
        return (value1 == null) ? (value2 == null) : value1.equals(value2);
    }
}
