package com.humandevice.validator.rules;

import android.text.TextUtils;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.utils.ValidatorUtils;
import com.humandevice.validator.widget.ValidatorView;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class NotEmptyRule extends Rule<NotEmptyRule> {
    @Override
    protected void checkView(ValidatorView view) throws ValidationException {
        String text = (String) ValidatorUtils.getValue(view);
        if (TextUtils.isEmpty(text)) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
        if (!ValidatorUtils.isTextView(view)) {
            throw new IllegalArgumentException("View must extends TextView");
        }
    }
}
