package com.humandevice.validator.rules;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class PhoneRule extends RegexRule {

    public static String sPhonePattern = "^[+]?[0-9]{9,12}$";

    private static boolean mIgnoreWhiteSpaces;

    /**
     * Default: <code>{@value sPhonePattern}</code>
     */
    public static void setPhonePattern(String phonePattern) {
        sPhonePattern = phonePattern;
    }

    public PhoneRule(boolean allowEmpty, boolean ignoreWhiteSpaces) {
        super(sPhonePattern, allowEmpty);
        mIgnoreWhiteSpaces = ignoreWhiteSpaces;
    }

    public PhoneRule(boolean allowEmpty) {
        super(sPhonePattern, allowEmpty);
    }

    public PhoneRule() {
        super(sPhonePattern);
    }

    @Override
    protected boolean isValid(String text) {
        if (mIgnoreWhiteSpaces){
            text = text.replaceAll("\\s+","");
        }
        return super.isValid(text);
    }
}
