package com.humandevice.validator.utils;

import android.widget.EditText;

import com.humandevice.validator.widget.ValidatorCheckBox;
import com.humandevice.validator.widget.ValidatorEditText;
import com.humandevice.validator.widget.ValidatorSwitch;
import com.humandevice.validator.widget.ValidatorTextInputLayout;
import com.humandevice.validator.widget.ValidatorView;

import java.util.Collection;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class ValidatorUtils {

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isLonger(String string, Integer length) {
        return !(string == null || length == null) && string.length() > length;
    }

    public static boolean isShorter(String string, Integer length) {
        return !(string == null || length == null) && string.length() < length;
    }

    public static Object getValue(ValidatorView view) {
        if (view instanceof ValidatorCheckBox) {
            return ((ValidatorCheckBox) view).isChecked();
        } else if (view instanceof ValidatorSwitch) {
            return ((ValidatorSwitch) view).isChecked();
        } else if (view instanceof ValidatorEditText) {
            return ((ValidatorEditText) view).getText().toString();
        } else if (view instanceof ValidatorTextInputLayout) {
            EditText editText = ((ValidatorTextInputLayout) view).getEditText();
            if (editText != null) {
                return editText.getText().toString();
            }
        }
        return null;
    }

    public static boolean isCheckableView(ValidatorView view){
        return view instanceof ValidatorCheckBox || view instanceof ValidatorSwitch;
    }

    public static boolean isTextView(ValidatorView view){
        return view instanceof ValidatorEditText || view instanceof ValidatorTextInputLayout;
    }

}
