package com.humandevice.validator.widget;

import android.support.annotation.NonNull;
import android.support.annotation.Size;

import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.rules.Rule;

import java.util.Set;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
public interface ValidatorView {

	/**
	 * Ustawienie nazwy pola dla walidacji
	 */
	void setName(String name);

	/**
	 * Pobranie nazwy pola używanej do walidacji
	 */
	String getName();

	/**
	 * Dodanie zasad walidacji
	 */
	void addRule(@NonNull Rule rule, Rule... otherRules);

	/**
	 * Dodanie zasad walidacji
	 */
	void addRules(@Size(min = 1) Rule[] rules);

	/**
	 * Pobranie wszystkich dodanych zasad walidacji
	 */
	Set<Rule> getRules();

	/**
	 * Sprawdzenie czy wartość jest poprawna
	 */
	boolean validate(int maxPriority);

	/**
	 * Pobranie errorów walidacji.<br />
	 * <i><b>Note:</b></i> Jeśli wcześniej nie została wykonana walidacja to zostanie zwrócona pusta lista
	 */
	Errors getErrors();

	/**
	 * Sprawdzenie czy pole posiada błędy.<br />
	 * <i><b>Note:</b></i> Jeśli wcześniej nie została wykonana walidacja to zostanie zwrócona pusta lista
	 */
	boolean hasErrors();

	void clearErrors();

	void showErrors();
}
