package com.humandevice.validator.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.util.AttributeSet;
import android.view.ViewParent;
import android.widget.AutoCompleteTextView;

import com.humandevice.validator.R;
import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.rules.Rule;
import com.humandevice.validator.utils.ErrorTextWatcher;

import java.util.Set;


@SuppressLint("AppCompatCustomView")
public class ValidatorAutoCompleteTextView extends AutoCompleteTextView implements ValidatorView {

	private ValidatorViewDelegator delegator = new ValidatorViewDelegator();

	public ValidatorAutoCompleteTextView(Context context) {
		super(context);
	}

	public ValidatorAutoCompleteTextView(Context context, AttributeSet attrs) {
		super(context, attrs);
		parseAttrs(context, attrs);
	}

	public ValidatorAutoCompleteTextView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		parseAttrs(context, attrs);
	}

	protected void parseAttrs(Context context, AttributeSet attrs) {
		TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ValidatorView, 0, 0);
		try {
			setName(a.getString(R.styleable.ValidatorView_name));
		} finally {
			a.recycle();
		}
	}

	@Override
	public void setName(String name) {
		delegator.setName(name);
	}

	@Override
	public String getName() {
		return delegator.getName();
	}

	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		delegator.addRule(rule, otherRules);
		initTextWatcher();
	}

	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		delegator.addRules(rules);
		initTextWatcher();
	}

	@Override
	public Set<Rule> getRules() {
		return delegator.getRules();
	}

	@Override
	public boolean validate(int maxPriority) {
		return delegator.validate(this, maxPriority);
	}

	@Override
	public Errors getErrors() {
		return delegator.getErrors();
	}

	@Override
	public boolean hasErrors() {
		return delegator.hasErrors();
	}

	@Override
	public void clearErrors() {
		delegator.clearErrors();
	}

	@Override
	public void showErrors() {
		ViewParent parent = getParent().getParent();
		if (parent instanceof ValidatorTextInputLayout) {
			if (delegator.hasErrors()) {
				((ValidatorTextInputLayout) parent).setError(delegator.getErrors().getCombinedMessage());
				((ValidatorTextInputLayout) parent).setErrorEnabled(true);
			} else {
				((ValidatorTextInputLayout) parent).setError(null);
				((ValidatorTextInputLayout) parent).setErrorEnabled(false);
			}
		} else {
			delegator.showErrors(this);
		}
	}

	protected void initTextWatcher() {
		ErrorTextWatcher textWatcher = new ErrorTextWatcher(this);
		removeTextChangedListener(textWatcher); //remove old textWatcher if was previously added
		addTextChangedListener(textWatcher);
	}

}
