package com.humandevice.validator.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.v7.widget.SwitchCompat;
import android.util.AttributeSet;

import com.humandevice.validator.R;
import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.rules.Rule;

import java.util.Set;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
public class ValidatorSwitch extends SwitchCompat implements ValidatorView {

	private ValidatorViewDelegator delegator = new ValidatorViewDelegator();

	public ValidatorSwitch(Context context) {
		super(context);
	}

	public ValidatorSwitch(Context context, AttributeSet attrs) {
		super(context, attrs);
		parseAttrs(context, attrs);
	}

	public ValidatorSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		parseAttrs(context, attrs);
	}

	protected void parseAttrs(Context context, AttributeSet attrs) {
		TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ValidatorView, 0, 0);
		try {
			setName(a.getString(R.styleable.ValidatorView_name));
		} finally {
			a.recycle();
		}
	}

	@Override
	public void setName(String name) {
		delegator.setName(name);
	}

	@Override
	public String getName() {
		return delegator.getName();
	}

	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		delegator.addRule(rule, otherRules);
	}

	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		delegator.addRules(rules);
	}

	@Override
	public Set<Rule> getRules() {
		return delegator.getRules();
	}

	@Override
	public boolean validate(int maxPriority) {
		return delegator.validate(this, maxPriority);
	}

	@Override
	public Errors getErrors() {
		return delegator.getErrors();
	}

	@Override
	public boolean hasErrors() {
		return delegator.hasErrors();
	}

	@Override
	public void clearErrors() {
		delegator.clearErrors();
	}

	@Override
	public void showErrors() {
		delegator.showErrors(this);
	}

}
