package com.humandevice.validator.widget;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.widget.TextView;

import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.rules.Rule;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
class ValidatorViewDelegator implements ValidatorView {

	private Set<Rule> rules = new TreeSet<>(new Rule.PriorityComparator());
	protected final Errors errors = new Errors();
	private String name;

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		rules.add(rule);
		Collections.addAll(rules, otherRules);
	}

	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		Collections.addAll(this.rules, rules);
	}

	@Override
	public Set<Rule> getRules() {
		return rules;
	}

	@Override
	public boolean validate(int maxPriority) {
		throw new RuntimeException("Stub!");
	}

	public boolean validate(ValidatorView view, int maxPriority) {
		view.getErrors().clear();
		int errorRulePriority = Integer.MIN_VALUE;
		boolean valid = true;
		for (Rule rule : view.getRules()) {
			if (rule.getPriority() > maxPriority) {
				break;
			}
			if (errorRulePriority != Integer.MIN_VALUE && errorRulePriority != rule.getPriority()) {
				break;
			}

			try {
				rule.validate(view);
			} catch (ValidationException e) {
				valid = false;
				view.getErrors().add(e.getValidationError());
				errorRulePriority = rule.getPriority();
			}
		}
		return valid;
	}

	@Override
	public Errors getErrors() {
		return errors;
	}

	@Override
	public boolean hasErrors() {
		return errors.hasErrors();
	}

	@Override
	public void clearErrors() {
		errors.clear();
	}

	@Override
	public void showErrors() {
		throw new RuntimeException("Stub!");
	}

	public void showErrors(TextView textView) {
		if (errors.hasErrors()) {
			textView.setError(errors.getCombinedMessage());
		} else {
			textView.setError(null);
		}
	}
}
